#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Sci-fi RoadwayMod01.fsh  by   JoaquinFraud  
//https://www.shadertoy.com/view/mlySW1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define FOV 3.
#define CURVE_FRQ .03
#define CURVE_AMT .07
#define SPEED 20.
#define LINES 4.
#define TEXTURE_STENGTH .1
#define DARKNESS 2.
#define BUILDING_DIST 2.
#define DTL_RANGE 2.
#define DTL_CHANGE .5

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    float speed = iTime * SPEED;
    float shade;
    // pixel pos between -1 and 1
    vec2 pos = fragCoord / (iResolution.xy / 2.) - 1.;

    // the offset of the road for each pixel
    float curve = sin((FOV * CURVE_FRQ) / -abs(pos.y) - (speed * CURVE_FRQ)) / abs(pos.y) * CURVE_AMT;
    float roadX = pos.x + curve;

    // texture
    shade = 1. - sin(FOV / pos.y - speed) * TEXTURE_STENGTH;

    // sky
    if (pos.y > 0.) shade = pos.y;
    // road
    else {
        if (abs(roadX) < -pos.y / 3.) shade = 0.;
        if (abs(roadX) < -pos.y / 30.) shade = sign(sin((FOV / pos.y - speed) * LINES));
    }

    // road border
    if (abs(roadX) < -pos.y / 3. && abs(roadX) > -pos.y / 4.) shade = .3;

    // bushes
    float dist = DTL_RANGE + floor(sin((FOV * DTL_CHANGE) / pos.y - (speed * DTL_CHANGE)) * DTL_RANGE);
    float size = 1. + sin(FOV / pos.y - speed) * .5;
    if (abs(roadX) > -pos.y * dist && abs(roadX) < -pos.y * dist * size && pos.y < 0.) shade = 0.;

    // gradient
    if (pos.y < 0.) shade *= -pos.y * DARKNESS;

    // vignette
    shade *= cos(pos.y * 1.1) * cos(pos.x * 1.1);

    fragColor = vec4(shade * (1. + cos(iTime / 3.) * .2), shade * (1. + sin(iTime / 2.) * .2), shade / .9, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

